/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model.turtle;

import com.google.common.cache.CacheBuilder;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.Holiday;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class TurtleModelParts<T> {
    private static final class_4590 identity;
    private static final class_4590 flip;
    private final class_1087 familyModel;
    private final class_1087 colourModel;
    private final Function<TransformedModel, class_1087> transformer;
    private final Function<Combination, T> buildModel;
    private final Map<TransformedModel, class_1087> transformCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(30L, TimeUnit.SECONDS).build().asMap();
    private final Map<Combination, T> modelCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(30L, TimeUnit.SECONDS).build().asMap();

    public TurtleModelParts(class_1087 familyModel, class_1087 colourModel, ModelTransformer transformer, Function<List<class_1087>, T> combineModel) {
        this.familyModel = familyModel;
        this.colourModel = colourModel;
        this.transformer = x -> transformer.transform(x.model(), x.matrix());
        this.buildModel = x -> combineModel.apply(this.buildModel((Combination)x));
    }

    public T getModel(class_1799 stack) {
        Combination combination = this.getCombination(stack);
        return this.modelCache.computeIfAbsent(combination, this.buildModel);
    }

    private Combination getCombination(class_1799 stack) {
        boolean christmas = Holiday.getCurrent() == Holiday.CHRISTMAS;
        UpgradeData<ITurtleUpgrade> leftUpgrade = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
        UpgradeData<ITurtleUpgrade> rightUpgrade = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
        TurtleOverlay overlay = TurtleItem.getOverlay(stack);
        String label = DataComponentUtil.getCustomName((class_9322)stack);
        boolean flip = label != null && (label.equals("Dinnerbone") || label.equals("Grumm"));
        return new Combination(stack.method_57826(class_9334.field_49644), leftUpgrade, rightUpgrade, overlay, christmas, flip);
    }

    private List<class_1087> buildModel(Combination combo) {
        boolean showChristmas;
        class_310 mc = class_310.method_1551();
        class_1092 modelManager = mc.method_1480().method_4012().method_3303();
        class_4590 transformation = combo.flip ? flip : identity;
        ArrayList<class_1087> parts = new ArrayList<class_1087>(4);
        parts.add(this.transform(combo.colour() ? this.colourModel : this.familyModel, transformation));
        if (combo.overlay() != null) {
            this.addPart(parts, modelManager, transformation, combo.overlay().model());
        }
        if (showChristmas = TurtleOverlay.showElfOverlay(combo.overlay(), combo.christmas())) {
            this.addPart(parts, modelManager, transformation, TurtleOverlay.ELF_MODEL);
        }
        this.addUpgrade(parts, transformation, TurtleSide.LEFT, combo.leftUpgrade());
        this.addUpgrade(parts, transformation, TurtleSide.RIGHT, combo.rightUpgrade());
        return parts;
    }

    private void addPart(List<class_1087> parts, class_1092 modelManager, class_4590 transformation, class_2960 model) {
        parts.add(this.transform(ClientPlatformHelper.get().getModel(modelManager, model), transformation));
    }

    private void addUpgrade(List<class_1087> parts, class_4590 transformation, TurtleSide side, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        if (upgrade == null) {
            return;
        }
        TransformedModel model = TurtleUpgradeModellers.getModel(upgrade.upgrade(), upgrade.data(), side);
        parts.add(this.transform(model.model(), transformation.method_22933(model.matrix())));
    }

    private class_1087 transform(class_1087 model, class_4590 transformation) {
        if (transformation.equals((Object)class_4590.method_22931())) {
            return model;
        }
        return this.transformCache.computeIfAbsent(new TransformedModel(model, transformation), this.transformer);
    }

    static {
        class_4587 stack = new class_4587();
        stack.method_46416(0.5f, 0.5f, 0.5f);
        stack.method_22905(1.0f, -1.0f, 1.0f);
        stack.method_46416(-0.5f, -0.5f, -0.5f);
        identity = class_4590.method_22931();
        flip = new class_4590(stack.method_23760().method_23761());
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ModelTransformer {
        public class_1087 transform(class_1087 var1, class_4590 var2);
    }

    @Environment(value=EnvType.CLIENT)
    private record Combination(boolean colour, @Nullable UpgradeData<ITurtleUpgrade> leftUpgrade, @Nullable UpgradeData<ITurtleUpgrade> rightUpgrade, @Nullable TurtleOverlay overlay, boolean christmas, boolean flip) {
    }
}

